------------------------------------------------------------
-- Randomize Shake Seeds
--
-- $Revision$
--
-- This comp script randomizes the values of the seed input
-- on all shake modifiers in the composition, unless the word 
-- 'locked' appears in the tool comments.
--
-- this is a comp type script, and must be run from the 
-- scripts/comp directory of fusion
--
-- written by Isaac Guenard, Oct 30th, 2003
-- Modified Aug 23rd, 2005 for Fusion 5
------------------------------------------------------------

tools = comp:GetToolList("Shake")
shake = {}
math.randomseed(os.time())

for i, tool in pairs(tools) do
	if tool:GetID()== "Shake" then
		comment = string.lower( tool.Comments[TIME_UNDEFINED] )
		str_start, str_end  = string.find(comment, "locked")
		if not str_start then
			tool.RandomSeed = math.random(32000)
		end
	end
end